function [x,retcode] = sigma_points(a,PP,scale)
retcode=0;

% -- Get Cholesky Decomposition -- %
[Pstar,check]=chol(PP,'lower');

% -- If PP Not Positive Definite, Project to Find Nearby One -- %
if check > 0
    
    % -- Run Cholesky Again -- %
    [Pstar,check]=chol(project(PP,1),'lower');
    
    % -- If Project(PP) not Positive Definite, Stop -- %
    if check > 0
        retcode = 999;
        x = 999;
        return
    end
end

% symmetrizing is not enough to get a positive definite matrix
Pstar = scale*Pstar;

% -- Find Sigma Points to right, left and center-- %
x = [bsxfun(@plus,a,Pstar),... points to the right
    bsxfun(@minus,a,Pstar)]; % points to the left
x = [a,x];



end